﻿/*	VERSION:  1.2
1.1		Allow parameters


USAGE:
	var updateOnce;		// use this to make this a local-only function
	#include "functions/updateOnce.as"
	
	my_func = function(){
		trace("derp?");
	}
	
	my_infrequent_func = updateOnce( my_func );
	
	// only runs once
	my_infrequent_func();
	my_infrequent_func();
	my_infrequent_func();
	my_infrequent_func();
	

DESCRIPTION:
	Runs a function only once per millisecond
	
*/
updateOnce = function( func, delay ){
	var hasUpdated = false;
	var interval = null;
	var delay = delay || 0;
	return function(){
		if(hasUpdated === false){
			// don't run again for awhile
			hasUpdated = true;
			
			// run the function
			func.apply( null, arguments );
			
			// wait before allowing it to be run again
			clearTimeout( interval );
			interval = setTimeout(function(){
				hasUpdated = false;
			}, delay);
		}// if:  has NOT run yet
	}// return new func()
}// updateOnce()